/******************************************************
 *                                                    *
 * ļ: 07 ͼ\01 MGraph                          *
 *                                                    *
 * ļ: MGraph.h                                   *
 *                                                    *
 *   : ͼ飨ڽӾ󣩱ʾزб *
 *                                                    *
 ******************************************************/

#ifndef MGRAPH_H
#define MGRAPH_H

#include <stdio.h>
#include <limits.h>											//ṩINT_MAX
#include <stdlib.h> 										//ṩrandsrandԭ 
#include <stdarg.h>											//ṩva_listva_startva_argva_end
#include "../../01 /Status.h"							//**01 **//
#include "../../01 /Scanf.c"							//**01 **//
#include "../../03 ջͶ/07 LinkQueue/LinkQueue.c" 	//**03 ջͶ**//

/* 궨 */
#define INFINITY INT_MAX						//ֵ
#define MAX_VERTEX_NUM 20						//󶥵 

/* ͼ飨ڽӾ󣩱ʾͶ */
typedef enum{ DG, DN, UDG, UDN }GraphKind;		//0-ͼ1-Ȩֵ2-ͼ3-Ȩֵ
typedef struct{ }InfoType;						//Ϣ
typedef int VRType;								//ͼϵ 
typedef struct ArcCell
{
	VRType adj;									//ȨͼбʾȨֵȨͼ01ʾǷ
	InfoType info;								//ûϢԺ 
}ArcCell;
typedef ArcCell AdjMatrix[MAX_VERTEX_NUM+1][MAX_VERTEX_NUM+1]; //ڽӾ 

/* ͼʾĴ洢ʾ */
typedef char VertexType_M;				//ͼ 
typedef struct
{
	VertexType_M vexs[MAX_VERTEX_NUM+1];//
	AdjMatrix arcs;						//ڽӾ
	int vexnum,	arcnum;					//ͼĵǰͻ
	int IncInfo;						//IncInfoΪ0Ϣ 
	GraphKind kind;						//ͼ־ 
}MGraph;

/* ȫֱ */
Status visited[MAX_VERTEX_NUM+1];		//־
void (*VisitFunc)(VertexType_M e);		//ָ 

/* ͼʾб */
Status CreateGraph_M(FILE *fp, MGraph *G);
/*
(01)㷨7.1ͼ 
*/

Status CreateDG_M(FILE *fp, MGraph *G);
/*
(02)ͼ
*/

Status CreateDN_M(FILE *fp, MGraph *G);
/*
(03)
*/ 

Status CreateUDG_M(FILE *fp, MGraph *G);
/*
(04)ͼ
*/

Status CreateUDN_M(FILE *fp, MGraph *G);
/*
(05)㷨7.2 
*/

void ClearGraph_M(MGraph *G);
/*
(06)ͼ
*/

int LocateVex_M(MGraph G, VertexType_M u);
/*
(07)ѰҶuλá 
*/

VertexType_M GetVex_M(MGraph G, int order);
/*
(08)صvֵ 
*/

Status PutVex_M(MGraph *G, VertexType_M v, VertexType_M value);
/*
(09)Զvֵvalue
*/

int FirstAdjVex_M(MGraph G, VertexType_M v);
/*
(10)vĵһڽӶš 
*/

int NextAdjVex_M(MGraph G, VertexType_M v, VertexType_M w);
/*
(11)vwһڽӶš
*/

Status InsertVex_M(MGraph *G, VertexType_M v);
/*
(12)붥vͼ 
*/

Status DeleteVex_M(MGraph *G, VertexType_M v);
/*
(13)ͼɾv 
*/

Status InsertArc_M(MGraph *G, VertexType_M v, VertexType_M w, VRType adj, ...);
/*
(14)뻡<v,w>ͼ,ϢInfoTypeѡ
*/

Status DeleteArc_M(MGraph *G, VertexType_M v, VertexType_M w);
/*
(15)ɾ<v,w> 
*/

void DFSTraverse_M(MGraph G, void(Visit)(VertexType_M));
/*
(16)㷨7.4ȱ 
*/

void DFS_M(MGraph G, int v);
/*
(17)㷨7.5ȱĺ 
*/

void BFSTraverse_M(MGraph G, void(Visit)(VertexType_M));
/*
(18)㷨7.6ȱ 
*/

void OutputMGraph(MGraph G);
/*
(19)ͼ
*/

void Input(FILE *fp, InfoType *info);
/*
(20)¼뻡Ϣ
*/

#endif
